/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter.gui.widget;

import net.minecraft.Util;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class SelectableFilenameField
extends EditBox {
    private final StringSplitter CHARACTER_MANAGER;
    public boolean allowExtensionModifications = false;
    private long lastClickTime = 0L;

    public SelectableFilenameField(Font fontRenderer, int x, int y, int width, int height, Component text) {
        super(fontRenderer, x, y, width, height, text);
        this.CHARACTER_MANAGER = fontRenderer.m_92865_();
    }

    public void toggleExtensionModifications() {
        this.allowExtensionModifications = !this.allowExtensionModifications;
        this.m_94196_(Math.min(this.m_94207_(), this.getEditableLength()));
        this.m_94208_(this.m_94207_());
    }

    public String getExtension() {
        int dotPos = this.m_94155_().lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        return this.m_94155_().substring(dotPos);
    }

    public int getEditableLength() {
        if (this.allowExtensionModifications) {
            return this.m_94155_().length();
        }
        return this.m_94155_().length() - this.getExtension().length();
    }

    public void highlightFilename() {
        this.m_94198_();
        this.m_94208_(this.getEditableLength());
    }

    public void updateShiftKeyStatus() {
        this.f_94099_ = Screen.m_96638_();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (!this.m_94204_()) {
            return false;
        }
        this.updateShiftKeyStatus();
        if (Screen.m_96634_((int)keyCode)) {
            this.highlightFilename();
            return true;
        }
        switch (keyCode) {
            case 261: 
            case 262: {
                if (this.m_94207_() < this.getEditableLength()) break;
                return false;
            }
            case 264: 
            case 269: {
                this.m_94196_(this.getEditableLength());
                return true;
            }
            case 265: {
                this.m_94198_();
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateShiftKeyStatus();
        if (super.m_6375_(mouseX, mouseY, button)) {
            if (Util.m_137550_() - this.lastClickTime < 250L) {
                this.highlightFilename();
                this.lastClickTime = 0L;
            } else {
                this.lastClickTime = Util.m_137550_();
                int editableLength = this.getEditableLength();
                if (this.m_94207_() > editableLength) {
                    this.m_94196_(editableLength);
                }
                this.m_94208_(this.m_94207_());
            }
            return true;
        }
        return false;
    }

    protected void m_7212_(double mouseX, double mouseY, double dragX, double dragY) {
        if (!this.m_93696_()) {
            return;
        }
        int relativeX = (int)mouseX - this.f_93620_;
        int dragCharPos = 0;
        if (relativeX > 0) {
            dragCharPos = this.CHARACTER_MANAGER.m_92410_(this.m_94155_(), relativeX, Style.f_131099_).length();
        }
        dragCharPos = Math.min(dragCharPos, this.getEditableLength());
        this.m_94208_(dragCharPos);
    }
}

